<report title="D2D - EMR DQ CHF Coded Numer v1" description="Lists patients with coded CHF diagnosis."
active="1">
<query>

    SELECT DISTINCT d.demographic_no Demographic, 
                    d.sex Sex, floor(datediff(curdate(),str_to_date(concat(d.year_of_birth,d.month_of_birth,d.date_of_birth),'%Y%m%d'))/365.25) Age, 
                    concat(d.last_name, ', ', d.first_name) Patient, 
                    concat(p.last_name, ', ', p.first_name) MRP
    FROM demographic d, provider p, dxresearch dx
    WHERE d.patient_status = 'AC'
    AND (dx.dxresearch_code = '428' AND dx.status = "A" AND d.demographic_no = dx.demographic_no)
    AND d.provider_no = p.provider_no
    ORDER by Demographic;

</query>

</report>